﻿<#-
Name: get-members.ps1
Author: Amy Herold
Date: 16 March 2015
Description: Reaches out to AD on network and pulls back users/groups contained in the groups. Adds users to a table and if there is a group adds that to the groups table.

WARNING: RUN THIS AT YOUR OWN RISK!!! NO WARRANTY OR GUARANTEE PROVIDED!!!

 -#>



Import-Module sqlps;


$db_server = "SERVER_NAME"
$db = "DBA_Admin"
$ADServer = "DOMAINNAME"
$ADCredential = Get-Credential "DOMAINNAME\newusername"


#$groups = @();
$groups = New-Object System.Collections.ArrayList;
$groupmembers = New-Object System.Collections.ArrayList;

#-------------------get the list of groups we have in the table and add them to the array----------#>
$sql_query = "select groupname, groupid from ADGroups"
    
$groups.AddRange(@(Invoke-Sqlcmd -ServerInstance $db_server -Database $db -Query $sql_query));


#-------------------list all global security groups in AD------------------------#>
#Get-ADGroup -Server $ADServer -Credential $ADCredential -filter {GroupCategory -eq "Security" -and GroupScope -eq "Global"}


<#-----------------for each group in the array, get all the members and groups in groups---------------#>
for ($i = 0;$i -lt ($groups | Measure-Object).count;$i++)
{

    $groupname = $groups[$i].groupname
    $groupid = $groups[$i].groupid
    
    write-host "***'$groupname' - '$groupid'***"

    $groupmembers.Clear();

    $groupmembers.AddRange(@(Get-ADGroupMember -Server $ADServer -Credential $ADCredential -Identity $groupname));
 
    foreach ($groupmember in $groupmembers)
    {

        $groupmember.name

        $objectClass_groupmember = $groupmember.objectClass;
        

        <#---------------if user, update user table------------------#>
        if ($objectClass_groupmember -eq "user")
        {
            $name = [regex]::Replace($groupmember.name,"'","''")
            $SamAccountName = $groupmember.SamAccountName


            #-----------------is the user enabled in AD?------------------------#>
            $IsEnabled = Get-ADUser  -Server $ADServer -Credential $ADCredential -Filter {samaccountname -eq $SamAccountName} | Select-Object -Property enabled
            [int]$enabled = [bool]$IsEnabled.enabled

            $sql_query = "MERGE INTO [dbo].[ADGroupMembers] AS Target
                            USING (VALUES ('$name', '$SamAccountName', $groupid, $enabled)) AS SOURCE (MemberName, MemberLogin, Groupid, IsEnabled)
                            ON TARGET.MemberLogin = SOURCE.MemberLogin and TARGET.Groupid = SOURCE.Groupid
                            WHEN MATCHED THEN
                            UPDATE SET IsEnabled = SOURCE.IsEnabled
                            WHEN NOT MATCHED THEN 
                            INSERT (MemberName, MemberLogin, Groupid, IsEnabled) VALUES (SOURCE.MemberName, SOURCE.MemberLogin, SOURCE.Groupid, SOURCE.IsEnabled);"

            
            Invoke-Sqlcmd -ServerInstance $db_server -Database $db -Query $sql_query
            
        }

          

        <#-----------------if group, add to groups table-----------------------#>
        if ($objectClass_groupmember -eq 'group')
        {
            $name = [regex]::Replace($groupmember.name,"'","''")
   
            
            #----------------group found - add group to table; will be processed next time the job is run-------------#>
            
            $sql_query = "if not exists (select 1 from ADGroups where groupname = '$name') insert ADGroups(groupname, alerts) values ('$name',0)"
            
            Invoke-Sqlcmd -ServerInstance $db_server -Database $db -Query $sql_query

        }

        
    }


}


$groupmembers.Clear();
$groups.Clear();