CREATE TABLE ADGroupMembers (MemberID INT IDENTITY(1,1), MemberName VARCHAR(200), MemberLogin VARCHAR(50), GroupID INT, IsEnabled bit)

CREATE TABLE ADGroups 
(GroupID INT IDENTITY(1,1)
, GroupName VARCHAR(200) NOT NULL
, NTLoginName VARCHAR(250) NOT NULL
, ServerName VARCHAR(50) NOT NULL
, ServerAlias VARCHAR(50) NOT NULL
, Alerts BIT NOT NULL DEFAULT 0
, DateAdded DATETIME2 NOT NULL DEFAULT CURRENT_TIMESTAMP)


truncate table ADGroups
truncate table ADGroupMembers


----insert groups into ADGroups - name passed in needs to equal the SamAccountName
INSERT ADGroups (GroupName, NTLoginName, ServerName, ServerAlias, Alerts)
VALUES ('SERVERAdmins','SERVERNAME\SERVER Admins','SERVERNAME','SERVER_ALIAS',1)
,('SERVERReports','SERVERNAME\SERVER Reporting','SERVERNAME','SERVER_ALIAS',0)


select * from ADGroupMembers

select * from ADGroups

------------query used - add group members to table----------------
MERGE ADGroupMembers AS target
USING (SELECT m.memberid, m.memberlogin, m.groupid
			FROM ADGroupMembers m 
			----INNER JOIN ADGroups g ON m.groupid = g.GroupID
			WHERE m.memberlogin = @membername AND m.groupid = @groupid) AS source (memberlogin, groupid)
ON (target.memberid = source.memberid)
WHEN MATCHED AND -- the login has been disabled --target.Quantity - source.OrderQty <= 0
    THEN DELETE
WHEN MATCHED 
    THEN UPDATE SET target.Quantity = target.Quantity - source.OrderQty, 
                    target.ModifiedDate = GETDATE()
OUTPUT $action, Inserted.ProductID, Inserted.Quantity, Inserted.ModifiedDate, Deleted.ProductID,
    Deleted.Quantity, Deleted.ModifiedDate;


select * from ADGroupMembers

select * from ADGroups