﻿<#-
Name: get_server_list.ps1
Author: Amy Herold
Date: 14 July 2014
Description: Returns list of SQL Server instances on a network.

WARNING: RUN THIS AT YOUR OWN RISK!!! NO WARRANTY OR GUARANTEE PROVIDED!!!

Notes:
This script does not account for multiple instances or named instances of SQL Server.

 -#>


"Step 1 - Create object to pull back list of servers";
$objSearcher = New-Object System.DirectoryServices.DirectorySearcher
$objSearcher.Filter = '(OperatingSystem=Window*Server*)'
 "Name","canonicalname","distinguishedname" | Foreach-Object {$null = $objSearcher.PropertiesToLoad.Add($_) }


#---------get list of all servers------------

"Step 2 - Get List of servers and save in variable";
$server_list = $objSearcher.FindAll() | Select-Object @{n='Name';e={$_.properties['name']}} 


#--------write out serverlist to window------
#$server_list.Name


#---------using $server_list, find only the servers where the service "MSSQLSERVER" is running--------
"Step 3 - From the list of servers, find all the ones where there is a MSSQLSERVER instance";
Get-Service -Name "MSSQLSERVER" -ComputerName $server_list.Name | Format-Table -Property MachineName -AutoSize