﻿<#-
Script: remove_user_access.ps1
Author: Amy Herold
Date: 14 July 2014
Purpose: Remove login(s) from a specific list of servers.

pass in list of users
pass in list of servers

0.5 - does the login exist at the server level? 
0.6 - does the user exist in any of the databases? could be in database without a login at the server.
0.7 - does the user own a schema?
1. does the user own anything? change the owner
2. has the user been added to a database? drop user from the database
3. are there any processes running under the user on the sql server? change the user the job runs under
4. drop login from the server
5. is the user an admin on the server - remove from the admins group

Things to change - 
keep a running list of sql sevrers in a table - make this table driven

WARNING: RUN THIS AT YOUR OWN RISK!!! NO WARRANTY OR GUARANTEE PROVIDED!!!


-#>

Import-Module sqlps;

$users = ''
$replica_status = ''
$server_array = New-Object System.Collections.ArrayList
$server_array.Clear();


<#--

$users = @('PresBusiness'
,'BadCop')
--#>


$users = @('EmmetBrickowski'
,'PresBusiness'
,'Wyldstyle'
,'Unikitty'
,'BadCop'
,'Vitruvius')




$servers = @('SERVER_A\SQLSERVER2012','SERVER_A');


#-------------add servers to an array-----------   
foreach($item in $servers)
{
    $server_array.Add(@($item.Split("\"))) | out-null;
}


#foreach ($server in $servers)
for ($i = 0;$i -lt ($server_array | Measure-Object).count;$i++)
{
    
    #----------get the sql server instance name-------------
    if ($server_array[$i][1] -eq $null)
    {
        $instance = "DEFAULT"
    }
    else
    {
        $instance = $server_array[$i][1]   
    }  

    $server1 =  '***********************SERVER: '+$server_array[$i][0]+"\"+$instance+'***********************************';
    $server1;
    $server_root = 'SQLSERVER:\sql\'+$server_array[$i][0];
    $location1 = $server_array[$i][0]+':\'+$instance+'\Databases\';
    #$location2 = $location1+$database;

    New-PSDrive -Name $server_array[$i][0] -Root $server_root -PSProvider SqlServer;
    
    #$location1 = $server+':\DEFAULT\Databases\';

    Set-Location $location1;

    #-----------------get list of databases on the server-----------------------
    $databases = ''
    $databases = Get-ChildItem 

    foreach ($user in $users)#-----------------accounting for passing in multiple users; doing this one user at a time rather than one server at a time
    { 
        foreach ($database in $databases)
        {
            #------------------check to see if the database is a mirror------------
            $is_mirror = 'select b.mirroring_role_desc
                            FROM sys.databases a
                            JOIN sys.database_mirroring b ON a.database_id = b.database_id
                            where a.name = '''+$database.Name+''';'                                  
            $is_mirror_status = Invoke-Sqlcmd $is_mirror;
            #$is_mirror_status = Invoke-Sqlcmd $is_mirror -SuppressProviderContextWarning;
            
            $version_check = 'SELECT @@version AS version';
            $version = Invoke-Sqlcmd $version_check;
            #$version = Invoke-Sqlcmd $version_check -SuppressProviderContextWarning;
            
            #-----------------if 2012, then check for hadr ------------------------
            if ($version.version -like '*Microsoft SQL Server 2012*')
            {
                $is_hadr_check = 'SELECT primary_replica from sys.dm_hadr_availability_group_states';
                $replica_status = invoke-sqlcmd $is_hadr_check;
                #$replica_status = invoke-sqlcmd $is_hadr_check -SuppressProviderContextWarning;
            }

            
            Write-Host 'mirror status = '$is_mirror_status.mirroring_role_desc;
            Write-Host 'HADR status = '$replica_status.primary_replica

            #----------------------------------is the database a mirror - if so, skip it----------------------
            if (($is_mirror_status.mirroring_role_desc -ne 'MIRROR' -or $is_mirror_status.mirroring_role_desc -eq $null) -and ($replica_status -eq $server_array[$i][0] -or $replica_status -eq $null)) 
            { 
                $location2 = $location1+$database.Name;
                $location2;                     
                Set-Location $location2;
            
                $drop_schema = 'IF EXISTS(SELECT * FROM sys.schemas WHERE name = '''+$user+''') DROP SCHEMA ['+$user+'];';  
                $drop_user = 'IF EXISTS(SELECT * FROM sys.sysusers WHERE name = '''+$user+''') DROP USER ['+$user+'];';

                $drop_schema;
                $drop_user; 

                Invoke-Sqlcmd $drop_schema;
                Invoke-Sqlcmd $drop_user;
                #Invoke-Sqlcmd $drop_schema -SuppressProviderContextWarning;
                #Invoke-Sqlcmd $drop_user -SuppressProviderContextWarning;
            }

        }
      
        
        #-----------------------------------go back to the server level-----------------------------------------
        $location1;
        Set-Location $location1;                  
        #-----------------------------------change db owner-----------------------------------------------------
        
        $owner_sql = ';WITH owners AS (SELECT a.name AS dbname , b.name AS owner_name, ''ALTER AUTHORIZATION ON DATABASE::[''+a.NAME+''] TO [sa];'' AS sql_code
                        FROM sys.databases a 
                        JOIN sys.server_principals b ON a.owner_sid = b.sid
                        WHERE b.name = '''+$user+''')
                        SELECT sql_code FROM owners;'


        $owner_change_sql = Invoke-Sqlcmd $owner_sql;
        #$owner_change_sql = Invoke-Sqlcmd $owner_sql -SuppressProviderContextWarning;

        
        foreach ($statement_change_owner in $owner_change_sql)
        {

            write-host $statement_change_owner.sql_code
            Invoke-Sqlcmd $statement_change_owner.sql_code;
            #Invoke-Sqlcmd $statement_change_owner.sql_code -SuppressProviderContextWarning;
        }
        

        #---------------------------------drop the login---------------------------------------------------------
        $login_sql =  'IF EXISTS(SELECT * FROM sys.syslogins WHERE name = '''+$user+''') DROP LOGIN ['+$user+'];';

        Write-Host $login_sql
        Invoke-Sqlcmd $login_sql;  
        #Invoke-Sqlcmd $login_sql -SuppressProviderContextWarning;
 
 
    }#end $users

    Set-Location c:\;
    Remove-PSDrive -Name $server_array[$i][0];

 
 }#end $servers


 