﻿<#-------------------------------------------------------------------------------------
Script: add_users_to_db.ps1
Author: Amy Herold
Date: 12 June 2014
Purpose: Add set of logins to specified server; Add to database and role.

- Revisions to be considered - 
sql server version check?
logins need to be the truncated value of 20 char or less - logic to truncate?
error handling - login already exists or user exists at the database? 
error handling - there is no such AD login?
param for role?

cannot run after it is run once - does not currently account for users that already exist


WARNING: RUN THIS AT YOUR OWN RISK!!! NO WARRANTY OR GUARANTEE PROVIDED!!!

--------------------------------------------------------------------------------------#>
Import-Module sqlps;


#------------------------------------params to pass in - update these-------------------------------------
#-----------------these need to be the abbreviated values...or logic can be written for this--------------
$users = '';
$servers = '';
$databases = '';


$users = @('EmmetBrickowski'
,'PresBusiness'
,'Wyldstyle'
,'Unikitty'
,'BadCop'
,'Vitruvius')

$servers = @('SERVER_A\SQLSERVER2012');
$databases = @('kragle');

$server_array = New-Object System.Collections.ArrayList
$server_array.Clear();



foreach($item in $servers)
{
    $server_array.Add(@($item.Split("\"))) | out-null;
}

#-------------------------------------------begin update--------------------------------------------------
for ($i = 0;$i -lt ($server_array | Measure-Object).count;$i++)
{

    if ($server_array[$i][1] -eq $null)
    {
        $instance = "DEFAULT"
    }
    else
    {
        $instance = $server_array[$i][1]   
    } 


    #-----------are these needed here?-----------------
    #Set-Location $location1;
    $server_root = 'SQLSERVER:\sql\'+$server_array[$i][0];
    $location1 = $server_array[$i][0]+':\'+$instance+'\Databases\';

    New-PSDrive -Name $server_array[$i][0] -Root $server_root -PSProvider SqlServer;
    #Set-Location $location1;


    foreach ($database in $databases)
    {
        $location2 = $location1+$database;
        Write-Host 'database location being updated = '$location2
        Set-Location $location2;

        foreach ($user in $users)
        {
            $create_user = 'CREATE USER ['+$user+'] FOR LOGIN ['+$user+']';

            #$create_user = 'if not exists (select * from sys.sysusers where name = '''+$user+''') CREATE USER ['+$user+'] FOR LOGIN ['+$user+']';
    
            #-------------SQL 2012 forward; not valid in 2008
            #$alter_role = 'ALTER ROLE [db_owner] ADD MEMBER ['+$user+']';


            #-------------will work in 2008 and 2012; from the documentation, also looks valid in 2014; will be deprecated 
            $alter_role1 = 'EXEC sp_addrolemember N''db_datareader'', N'''+$user+''''
            $alter_role2 = 'EXEC sp_addrolemember N''db_datawriter'', N'''+$user+''''

            $create_user;
            $alter_role1;
            $alter_role2;

            Invoke-Sqlcmd $create_user;
            Invoke-Sqlcmd $alter_role1;
            Invoke-Sqlcmd $alter_role2;


            #Invoke-Sqlcmd $create_user;
            #Invoke-Sqlcmd $alter_role;
        }
    }
    
    #change location and drop the drive
    Set-Location c:\;
    Remove-PSDrive -Name $server_array[$i][0];
}

#------------------------------------------- end update----------------------------------------------------

